package com.hero.util;

import java.io.File;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class XSLTransform {

	/**
	 * Transforms the given source Document according to the XSL stylesheet
	 * contained in the given File.
	 * 
	 * @param sourceDoc
	 * @param stylesheetFile
	 * @return
	 * @throws Exception
	 */
	public static Document transform(Document sourceDoc, File stylesheetFile)
			throws Exception {
		// Set up the XSLT stylesheet for use with Xalan-J 2
		TransformerFactory transformerFactory = TransformerFactory
				.newInstance();
		Templates stylesheet = transformerFactory
				.newTemplates(new StreamSource(stylesheetFile));
		Transformer processor = stylesheet.newTransformer();
		// Use I/O streams for source files
		PipedInputStream sourceIn = new PipedInputStream();
		PipedOutputStream sourceOut = new PipedOutputStream(sourceIn);
		StreamSource source = new StreamSource(sourceIn);
		// Use I/O streams for output files
		PipedInputStream resultIn = new PipedInputStream();
		PipedOutputStream resultOut = new PipedOutputStream(resultIn);
		// Convert the output target for use in Xalan-J 2
		StreamResult result = new StreamResult(resultOut);
		// Get a means for output of the JDOM Document
		XMLOutputter xmlOutputter = new XMLOutputter();
		Format format = Format.getPrettyFormat();
		xmlOutputter.setFormat(format);
		// Output to the I/O stream
		xmlOutputter.output(sourceDoc, sourceOut);
		sourceOut.close();
		// Feed the resultant I/O stream into the XSLT processor
		processor.transform(source, result);
		resultOut.close();
		// Convert the resultant transformed document back to JDOM
		SAXBuilder builder = new SAXBuilder();
		Document resultDoc = builder.build(resultIn);
		return resultDoc;
	}

}